% -------------------------------------------------------------------
% Este script hace la figura en la que se resuelve la ecuacin para
% la descomposicin de una especie radiactiva usando el mtodo de Euler.
% Usamos dos tamaos de paso para comprobar el efecto de reducir el tamao
% de paso.
% Este script requiere que en el espacio de trabajo exista la
% funcin feuler.
% dy/dx = f(x,y;k) = - k*y:
% -------------------------------------------------------------------

%Definiciones y parmetros

k=1;
fun = @(t,y) -k*y;
y0=100;
t0=0;
tf=5;

%Primera evaluacin de la solucin usando el mtodo de Euler con 10 pasos

Nh1=10;
[t1,y1]=feuler(fun,t0,tf,y0,Nh1);

%Segunda evaluacin de la solucin usando el mtodo de Euler con 20 pasos

Nh2=20;
[t2,y2]=feuler(fun,t0,tf,y0,Nh2);

%Solucin exacta

tp=0:0.1:5;
yp=y0*exp(-k*tp);

%Representamos la figura

plot(tp,yp,t1,y1,'or',t2,y2,'+k');
xlabel('t');
ylabel('N');
title('Mtodo de Euler');
legend('Sol. exacta','Sol. numrica h=0.5','Sol. numrica h=0.25');
text(2,70,'k=1');
